/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.RandomStringUtils;

public final class ItemStacks {
    private static final int WILDCARD = Short.MAX_VALUE;

    @Nonnull
    public static final ItemStack NULLSTACK() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static final ItemStack safe(@Nullable ItemStack stack) {
        return stack == null ? ItemStacks.NULLSTACK() : stack;
    }

    public static final int getSize(@Nullable ItemStack stack) {
        return stack != null ? stack.func_190916_E() : 0;
    }

    public static final boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack.func_190926_b();
    }

    public static final boolean isSingle(@Nullable ItemStack stack) {
        return stack != null ? stack.func_190916_E() == 1 : false;
    }

    public static final void setSingle(@Nonnull ItemStack stack) {
        if (stack != ItemStack.field_190927_a) {
            stack.func_190920_e(1);
        }
    }

    public static final boolean setSize(@Nullable ItemStack stack, int size) {
        boolean is = true;
        if (stack != null && stack != ItemStack.field_190927_a) {
            stack.func_190920_e(size);
            is = stack.func_190926_b();
        }
        return is;
    }

    public static final boolean decrBy(@Nullable ItemStack stack, int by) {
        boolean is = true;
        if (stack != null && stack != ItemStack.field_190927_a) {
            stack.func_190918_g(by);
            is = stack.func_190926_b();
        }
        return is;
    }

    public static final void incrBy(@Nullable ItemStack stack, int by) {
        if (stack != null && stack != ItemStack.field_190927_a) {
            stack.func_190917_f(by);
        }
    }

    public static final boolean areItemStacksEqual(@Nullable ItemStack stackA, @Nullable ItemStack stackB) {
        return stackA == null && stackB == null ? true : (stackA != null && stackB != null ? ItemStack.func_77989_b((ItemStack)stackA, (ItemStack)stackB) : false);
    }

    public static final boolean areEqualWildcardIgnoreAmountsAndTags(ItemStack a, ItemStack b) {
        return !ItemStacks.isEmpty(a) && !ItemStacks.isEmpty(b) ? (a.func_77973_b() == b.func_77973_b() ? a.func_77960_j() == Short.MAX_VALUE || b.func_77960_j() == Short.MAX_VALUE : false) : false;
    }

    public static final boolean areEqualIgnoreAmountsAndTags(ItemStack a, ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) ? true : ItemStacks.areEqualWildcardIgnoreAmountsAndTags(a, b);
    }

    @Nullable
    public static ItemStack copyItemStack(@Nullable ItemStack stack) {
        return stack == null ? null : (stack == ItemStack.field_190927_a ? ItemStack.field_190927_a : stack.func_77946_l());
    }

    @Nullable
    public static ItemStack copyItemStackSingle(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack == ItemStack.field_190927_a) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(1);
        return copy;
    }

    @Nullable
    public static ItemStack copyItemStack(@Nonnull ItemStack stack, int n) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(Math.max(0, n));
        return copy;
    }

    @Nonnull
    public static ItemStack copyDisplayName(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        NBTTagCompound displayData;
        if (from != to && from.func_77942_o() && (displayData = from.func_179543_a("display")) != null) {
            if (displayData.func_150297_b("Name", 8)) {
                to.func_151001_c(displayData.func_74779_i("Name"));
            }
            if (displayData.func_150297_b("LocName", 8)) {
                to.func_190924_f(displayData.func_74779_i("LocName"));
            }
        }
        return to;
    }

    @Nonnull
    public static ItemStack copyWithUnlocalizedName(@Nonnull ItemStack stack, String key) {
        stack.func_190924_f(key);
        return stack;
    }

    @Nonnull
    public static final NBTTagCompound getTagCompoundNonNull(@Nonnull ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static final NBTTagCompound getTagCompoundNonNull(@Nonnull ItemStack stack, String key) {
        return stack.func_190925_c(key);
    }

    public static final void setStackUnlocalizedName(ItemStack stack, String key) {
        if (!ItemStacks.isEmpty(stack)) {
            stack.func_190924_f(key);
        }
    }

    public static final void stampUnique(@Nonnull NBTTagCompound subcompound, String prefix, String chaosString) {
        if (prefix == null) {
            prefix = "";
        }
        if (chaosString == null) {
            chaosString = prefix + System.nanoTime() + RandomStringUtils.randomAlphanumeric((int)6);
        }
        subcompound.func_74778_a("CHAOS", chaosString);
    }

    public static final void stampUnique(@Nonnull ItemStack stack, String prefix) {
        ItemStacks.stampUnique(ItemStacks.getTagCompoundNonNull(stack), prefix, null);
    }

    @Nonnull
    public static final IBlockState toBlock(@Nullable ItemStack sourcestack, @Nullable Block sourceblock) {
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        if (ItemStacks.isEmpty(sourcestack)) {
            return air;
        }
        if (sourceblock == null) {
            sourceblock = Block.func_149634_a((Item)sourcestack.func_77973_b());
        }
        return sourceblock == Blocks.field_150350_a ? air : sourceblock.func_176203_a(sourcestack.func_77960_j());
    }

    @Nonnull
    public static final IBlockState toBlock(@Nullable ItemStack sourcestack) {
        return ItemStacks.toBlock(sourcestack, null);
    }

    @Nonnull
    public static final ItemStack fromBlock(@Nullable IBlockState sourceblock) {
        if (sourceblock == null || sourceblock.func_177230_c() == Blocks.field_150350_a) {
            return ItemStacks.NULLSTACK();
        }
        int meta = sourceblock.func_177230_c().func_176201_c(sourceblock);
        return new ItemStack(sourceblock.func_177230_c(), 1, meta);
    }

    public static final float getDurabilityLeft(@Nonnull ItemStack stack) {
        return ItemStacks.isEmpty(stack) ? 0.0f : 1.0f - (float)stack.func_77952_i() / (float)stack.func_77958_k();
    }

    public static final float getDurabilityUsed(@Nonnull ItemStack stack) {
        return ItemStacks.isEmpty(stack) ? 1.0f : (float)stack.func_77952_i() / (float)stack.func_77958_k();
    }

    public static final boolean isFlaggedUnbreakable(@Nonnull ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("Unbreakable");
    }

    public static final boolean isFlaggedVanishing(@Nonnull ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("Vanishing");
    }

    private ItemStacks() {
    }

    public static final void init() {
    }
}

